/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.events.*;

public class ToolItem extends Item {

ToolBar parent;

public ToolItem (ToolBar parent, int style) {
	super (parent, style);
}

public ToolItem (ToolBar parent, int style, int index) {
	super (parent, style, index);
}

public void addSelectionListener (SelectionListener listener) {
}

protected void checkSubclass () {
}


void createWidget (Display display, Widget parent, int style, int index) {
	this.parent = (ToolBar) parent;
	super.createWidget (display, parent, style, index);
	init();
	_createHandle (parent, style, index);
	hookEvents ();
}

public Rectangle getBounds (){
	Rectangle rectangle = new Rectangle(0,0,0,0);
	_setFromNativeBounds(rectangle);
	return rectangle;
}

public Control getControl () {
	System.out.println("ToolItem.getControl()");
	return null;
}

public Image getDisabledImage () {
	System.out.println("ToolItem.getDisabledImage()");
	return null;
}

public boolean getEnabled () {
	System.out.println("ToolItem.getEnabled()");
	return false;
}

public Image getHotImage () {
	System.out.println("ToolItem.getHotImage()");
	return null;
}

public ToolBar getParent () {
	return null;
}

public boolean getSelection () {
	System.out.println("ToolItem.getSelection()");
	return false;
}

public String getToolTipText () {
	return "";
}

public int getWidth () {
	return 0;
}

public boolean isEnabled () {
	return false;
}

public void removeSelectionListener (SelectionListener listener) {
}

public void setControl (Control control) {
}

public void setDisabledImage (Image image) {
}

public void setEnabled (boolean enabled) {
}

public void setHotImage (Image image) {
}

public void setImage (Image image) {
	checkWidget ();
//TODO not throw exception
//	if (image != null && image.isDisposed()) error(SWT.ERROR_INVALID_ARGUMENT);
//TODO why SWT.ARROW in the case of DROP_DOWN is returning true	
//	if ((style & SWT.ARROW) != 0) return;
	this.image = image;
	_setImage (image.imagePath);
}

protected void setParent(Widget parent){	
	_setParent(parent);
}

public void setSelection (boolean selected) {
}

public void setText (String string){
	_setText(string);
}

public void setToolTipText (String string) {
}

public void setWidth (int width) {
}

/*---------------------- NATIVE INTERFACE -------------------*/

protected native void _createHandle (Widget parent, int style, int index) /*-{
	if((style & (@org.eclipse.swt.SWT::DROP_DOWN)) != 0) {
		if(!$wnd.dojo._hasResource["org.eclipse.swt.ComboButton"]){
			$wnd.dojo._hasResource["org.eclipse.swt.ComboButton"] = true;
			$wnd.dojo.provide("org.eclipse.swt.ComboButton");
			
			$wnd.dojo.require("dijit.form.Button");
			$wnd.dojo.require("dijit.Menu");
		
			$wnd.dojo.declare("org.eclipse.swt.ComboButton", $wnd.dijit.form.ComboButton, {
				wrap: "nowrap",
				resize: function(){},
				setAlignment: function(alignment){
					this.domNode.align = alignment;
				},
				setLabel: function(content){
					this.containerNode.innerHTML = this.label = content;
					this.containerNode.style.whiteSpace = this.wrap;
					this.dim.w=this.label.length*12+20;
					this.dim.h=30;
				},
				setWidgetBounds: function(dim){
					this.dim = $wnd.swt.copyBounds(dim);
					this.focusNode.style.width = this.dim.w;
					this.focusNode.style.height = this.dim.h;
					$wnd.dojo.marginBox(this.domNode, this.dim);
				}
			});
		}
	}
	if((style & (@org.eclipse.swt.SWT::PUSH)) != 0) {
		if(!$wnd.dojo._hasResource["org.eclipse.swt.Button"]){
			$wnd.dojo._hasResource["org.eclipse.swt.Button"] = true;
			$wnd.dojo.provide("org.eclipse.swt.Button");
			
			$wnd.dojo.require("dijit.form.Button");
		
			$wnd.dojo.declare("org.eclipse.swt.Button", $wnd.dijit.form.Button, {
				wrap: "nowrap",
				resize: function(){},
				setAlignment: function(alignment){
					this.domNode.align = alignment;
				},
				setLabel: function(content){
					this.containerNode.innerHTML = this.label = content;
					this.containerNode.style.whiteSpace = this.wrap;
					this.dim.w=this.label.length*12;
//					this.setWidgetBounds(this.dim);
				},
				setWidgetBounds: function(dim){
					this.dim = $wnd.swt.copyBounds(dim);
					this.focusNode.style.width = this.dim.w;
					this.focusNode.style.height = this.dim.h;
					$wnd.dojo.marginBox(this.domNode, this.dim);
				}
			});
		}
	}
	
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	
	if((style & (@org.eclipse.swt.SWT::DROP_DOWN)) != 0) {
		var self = new $wnd.org.eclipse.swt.ComboButton({dropDown: new $wnd.dijit.Menu({})},$doc.createElement("div"));        	
	} else
	if((style & (@org.eclipse.swt.SWT::PUSH)) != 0) {
		var self = new $wnd.org.eclipse.swt.Button({},$doc.createElement("div"));
	} else {
		var self = new $wnd.org.eclipse.swt.Button({},$doc.createElement("div"));
	}
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		jsParent.addChild(self);
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}
}-*/;

native void _hookEvents (String eventType, int style) /*-{
	var self = this;
	$wnd.dojo.connect(
		self.@org.eclipse.swt.widgets.Widget::jsObject.domNode,
		eventType, 
		function(arg){
			arg.preventDefault();
			var event = self.@org.eclipse.swt.widgets.Widget::getEvent()();
			if (arg.target.parentNode) {
				if ((arg.target.parentNode.className).match("DownArrow")) {
					event.@org.eclipse.swt.widgets.Event::detail = @org.eclipse.swt.SWT::ARROW;
				}
			}
			event.@org.eclipse.swt.widgets.Event::type = style;
			event.@org.eclipse.swt.widgets.Event::x = arg.pageX;
			event.@org.eclipse.swt.widgets.Event::y = arg.pageY;
			self.@org.eclipse.swt.widgets.Widget::sendEvent(ILorg/eclipse/swt/widgets/Event;)(style, event);
		}
	);
}-*/;

native void _setFromNativeBounds (Rectangle rectangle) /*-{
	var dim = this.@org.eclipse.swt.widgets.Widget::jsObject.dim;
	rectangle.@org.eclipse.swt.graphics.Rectangle::x=dim.l;
	rectangle.@org.eclipse.swt.graphics.Rectangle::y=dim.t;
	rectangle.@org.eclipse.swt.graphics.Rectangle::width=dim.w;
	rectangle.@org.eclipse.swt.graphics.Rectangle::height=dim.h;
}-*/;

native void _setImage (String image) /*-{
	var self = this.@org.eclipse.swt.widgets.Widget::jsObject;
	var imgPath = "url("+image+")";
	self.iconNode.style.backgroundImage=imgPath;
	self.iconNode.style.backgroundRepeat= "no-repeat"; 
	self.iconNode.style.width= 18;
	self.iconNode.style.height= 18;
	self.iconNode.style.textAlign= "center";
	self.iconNode.style.backgroundPosition= -18;
	//TODO vefirier if necessary to modify the size after setImage	
	//self.dim.w += 25;
	//self.setWidgetBounds(self.dim);
}-*/;

native void _setParent(Widget parent)/*-{
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	var self = this.@org.eclipse.swt.widgets.Widget::jsObject;
	jsParent.addChild(self);
}-*/;

public native void _setText (String string) /*-{
	this.@org.eclipse.swt.widgets.Widget::jsObject.setLabel(string);
}-*/;

}
